/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.humanoid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.assets.entities.humanoid.model.HumanoidBodyType;
import technology.rocketjump.undermount.assets.entities.humanoid.model.HumanoidEntityAsset;
import technology.rocketjump.undermount.entities.model.physical.humanoid.Gender;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HumanoidEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.humanoid.Race;
import technology.rocketjump.undermount.jobs.ProfessionDictionary;
import technology.rocketjump.undermount.jobs.model.Profession;

public class HumanoidEntityAssetsByProfession {
    private Map<String, List<HumanoidEntityAsset>> professionNameMap = new HashMap<String, List<HumanoidEntityAsset>>();
    public static final HumanoidEntityAsset NULL_ENTITY_ASSET = new HumanoidEntityAsset();

    public HumanoidEntityAssetsByProfession() {
        this.professionNameMap.put(ProfessionDictionary.NULL_PROFESSION.getName(), new ArrayList());
    }

    public void add(HumanoidEntityAsset asset) {
        List<HumanoidEntityAsset> assets;
        String professionName = asset.getProfession();
        if (professionName == null) {
            professionName = ProfessionDictionary.NULL_PROFESSION.getName();
        }
        if ((assets = this.professionNameMap.get(professionName)) == null) {
            assets = new ArrayList<HumanoidEntityAsset>();
            this.professionNameMap.put(professionName, assets);
        }
        assets.add(asset);
    }

    public HumanoidEntityAsset get(HumanoidEntityAttributes attributes, Profession primaryProfession) {
        List<HumanoidEntityAsset> assetsForProfession = this.professionNameMap.get(primaryProfession.getName());
        if (assetsForProfession == null || assetsForProfession.isEmpty()) {
            assetsForProfession = this.professionNameMap.get(ProfessionDictionary.NULL_PROFESSION.getName());
        }
        if (assetsForProfession == null || assetsForProfession.isEmpty()) {
            return NULL_ENTITY_ASSET;
        }
        return assetsForProfession.get(Math.abs((int)attributes.getSeed()) % assetsForProfession.size());
    }

    public List<HumanoidEntityAsset> getAll(HumanoidEntityAttributes attributes, Profession primaryProfession) {
        List<HumanoidEntityAsset> assetsForProfession = this.professionNameMap.get(primaryProfession.getName());
        if (assetsForProfession == null || assetsForProfession.isEmpty()) {
            assetsForProfession = this.professionNameMap.get(ProfessionDictionary.NULL_PROFESSION.getName());
        }
        return assetsForProfession;
    }

    static {
        NULL_ENTITY_ASSET.setBodyType(HumanoidBodyType.ANY);
        NULL_ENTITY_ASSET.setGender(Gender.ANY);
        NULL_ENTITY_ASSET.setRace(Race.ANY);
        NULL_ENTITY_ASSET.setType(null);
        NULL_ENTITY_ASSET.setUniqueName("None");
    }
}

